using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using MySql.Data;
using MySql.Data.MySqlClient;

public partial class Pages_in_repeater : System.Web.UI.Page
{
    protected void Page_Load(object sender, System.EventArgs e)
    {

        // When this page load we first check to see that the keyword parameter not is null.
        if (Request.QueryString["keyword"] != null)
        {
            HiddenKeyWord.Value = Request.QueryString["keyword"];

            // ////////////////////// Navigation with previous and next links /////////////////////////
            // We select data to a repeater control and split up the datalist in
            // pages with previous and next links for navigation.

            string ConnString = ConfigurationManager.ConnectionStrings["ConnectionString"].ToString();
            string sql = "SELECT * FROM content WHERE MetaKeywords LIKE @Keywords ORDER BY Name ASC";

            // The Using block is used to call dispose (close) automatically even if there are an exception.
            using (MySqlConnection cn = new MySqlConnection(ConnString))
            {
                // Create Adapter, Command, DataTable and PagedDataSource.
                MySqlDataAdapter sad = new MySqlDataAdapter();
                MySqlCommand cmd = new MySqlCommand(sql, cn);
                DataTable dt = new DataTable();
                PagedDataSource objPds = new PagedDataSource();

                // Add parameters.
                cmd.Parameters.AddWithValue("@Keywords", "%" + HiddenKeyWord.Value + "%");

                // The Try/Catch/Finally block is used to handle exceptions.
                try
                {
                    // Open the connection.
                    cn.Open();

                    // Set the SelectCommand for the adapter.
                    sad.SelectCommand = cmd;

                    // Fill the DataTable with data from the adapter
                    sad.Fill(dt);

                    // Populate the paged data source with the datatable 
                    objPds.DataSource = dt.DefaultView;

                    // Indicate that the data should be paged 
                    objPds.AllowPaging = true;

                    // Set the pagesize 
                    objPds.PageSize = 10;

                    // The current page (curpage) is declared as an integer
                    Int32 curpage;

                    // We set the page number for the current page from the page parameter in the url
                    // or to 1 if there are no page parameter in the url

                    if (Request.QueryString["page"] != null)
                    {
                        curpage = Convert.ToInt32(Request.QueryString["page"]);
                    }
                    else
                    {
                        curpage = 1;
                    }

                    // The current page index is equal to the current page minus 1 and we need to know this
                    // to show the right page to the user.
                    objPds.CurrentPageIndex = curpage - 1;

                    // We set the text in the middle to show the current pagenumber and the last pagenumber
                    lblCurrentPage.Text = "| Page: " + curpage.ToString() + " of " + objPds.PageCount.ToString() + " |";

                    // This is code for the link to the previous page, we don't show this link on the first page
                    if (!objPds.IsFirstPage)
                    {
                        lnkPrev.Visible = true;
                        lnkPrev.NavigateUrl = "~/Pages-in-repeater.aspx?" + "keyword=" + HiddenKeyWord.Value + "&page=" + Convert.ToString(curpage - 1);
                    }

                    // This is code for the link to the next page, we don't show this link on the last page
                    if (!objPds.IsLastPage)
                    {
                        lnkNext.Visible = true;
                        lnkNext.NavigateUrl = "~/Pages-in-repeater.aspx?" + "keyword=" + HiddenKeyWord.Value + "&page=" + Convert.ToString(curpage + 1);
                    }

                    // This code is used to bind data to the repeater control
                    ContentListRepeater.DataSource = objPds;
                    ContentListRepeater.DataBind();

                }
                catch (Exception ex)
                {
                    Response.Write(ex.Message);
                }
                finally
                {
                    // Dispose of resources.
                    sad.Dispose();
                    cmd.Dispose();
                    dt.Dispose();
                }
            }

            // ////////////////////// Navigation with number links /////////////////////////
            // We select data to a repeater control and split up the datalist in
            // pages with number links for navigation.


            string ConnString2 = ConfigurationManager.ConnectionStrings["ConnectionString"].ToString();
            string sql2 = "SELECT * FROM content WHERE MetaKeywords LIKE @Keywords ORDER BY Name ASC";

            // The using block is used to call dispose (close) automatically even if there are an exception.
            using (MySqlConnection cn = new MySqlConnection(ConnString2))
            {
                // Create Adapter, Command, DataTable and PagedDataSource.
                MySqlDataAdapter sad = new MySqlDataAdapter();
                MySqlCommand cmd = new MySqlCommand(sql2, cn);
                DataTable dt = new DataTable();
                PagedDataSource objPds = new PagedDataSource();

                // Add parameters.
                cmd.Parameters.AddWithValue("@Keywords", "%" + HiddenKeyWord.Value + "%");

                // The Try/Catch/Finally block is used to handle exceptions.
                try
                {
                    // Open the connection.
                    cn.Open();

                    // Set the SelectCommand for the adapter.
                    sad.SelectCommand = cmd;

                    // Fill the DataTable with data from the adapter.

                    sad.Fill(dt);

                    // Populate the paged datasource with the datatable 
                    objPds.DataSource = dt.DefaultView;

                    // Indicate that the data should be paged 
                    objPds.AllowPaging = true;

                    // Set the pagesize 
                    objPds.PageSize = 10;

                    // The current page (curpage) is declared as an integer
                    Int32 curpage;

                    // We set the page number for the current page from the page parameter in the url
                    // or to 1 if there are no page parameter in the url
                    if (Request.QueryString["page"] != null)
                    {
                        curpage = Convert.ToInt32(Request.QueryString["page"]);
                    }
                    else
                    {
                        curpage = 1;
                    }

                    // The current page index is equal to the current page minus 1 and we need to know this
                    // to show the right page to the user.
                    objPds.CurrentPageIndex = curpage - 1;

                    // This code is to set the links for the pages in the repeater and the links are
                    // made up of pagenumbers. We set one link for each page in a literal control.
                    int NumberOfPages = objPds.PageCount - 1;

                    for (int i = 0; i <= NumberOfPages; i++)
                    {
                        litPages.Text += " <a href=\"" + "Pages-in-repeater.aspx?keyword=" + HiddenKeyWord.Value + "&amp;page=" + (i + 1) + "\">" + (i + 1) + "</a>";
                    }

                    // This code binds the data to the repeater control
                    ListRepeater2.DataSource = objPds;
                    ListRepeater2.DataBind();

                }
                catch (Exception ex)
                {
                    Response.Write(ex.Message);
                }
                finally
                {
                    // Dispose of resources.
                    sad.Dispose();
                    cmd.Dispose();
                    dt.Dispose();
                }
            }
        }
    }

    protected void btnGetKeyword_Click(object sender, System.EventArgs e)
    {
        // When the user clicks the "Get keyword" button we send the parameter for the keyword in the url
        Response.Redirect("Pages-in-repeater.aspx?keyword=" + txtKeyword.Text);

    }

    protected string GenerateURL(object Contentname)
    {
        //Create SEO Friendly URL for each content link
        string strConUrl = "~/article/" + Contentname + ".aspx";

        return strConUrl;
    }
}
